package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.ReviewTemplate;
import gov.va.vinci.dart.db.ReviewTemplateDAO;

public class ReviewTemplateDAOMock implements ReviewTemplateDAO {
	private static final HashMap<Integer,ReviewTemplate> IDHash = new HashMap<Integer,ReviewTemplate>();
	private static final HashMap<Integer,ReviewTemplate> GroupIDHash = new HashMap<Integer,ReviewTemplate>();
	
	private static boolean initialized = false;

	@Override
	public ReviewTemplate findById(int reviewTemplateId)
			throws ObjectNotFoundException {
		initializeReviewTemplateHash();
		
		ReviewTemplate result = IDHash.get(reviewTemplateId);
		
		if (result == null) {
			throw new ObjectNotFoundException();
		}

		return result;
	}

	@Override
	public ReviewTemplate findByGroupId(int groupId)
			throws ObjectNotFoundException {
		initializeReviewTemplateHash();

		ReviewTemplate result = GroupIDHash.get(groupId);
		
		if (result == null) {
			throw new ObjectNotFoundException();
		}

		return result;
	}

	@Override
	public List<ReviewTemplate> listAll() {
		List<ReviewTemplate> result = new ArrayList<ReviewTemplate>();
		
		initializeReviewTemplateHash();
		
		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}

		return result;	
	}

	@Override
	public List<ReviewTemplate> listAllActive() {
		List<ReviewTemplate> result = new ArrayList<ReviewTemplate>();
		
		initializeReviewTemplateHash();
		
		for (Integer id: IDHash.keySet()) {
			ReviewTemplate template = IDHash.get(id);
			if( template.getActive() == true ) {
				result.add(template);
			}//end if
		}//end for

		return result;	
	}

	
	private void initializeReviewTemplateHash() {
		if (initialized == true) {
			return;
		}
		
		initialized = true;
		
		try {
			initializeReviewTemplateHash0();
		} catch (ObjectNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	private void initializeReviewTemplateHash0() throws ObjectNotFoundException {
		
		ReviewTemplate rt = new ReviewTemplate();
		rt.setId(1);
		rt.setName("Privacy Review");
		rt.setActive(true);
		rt.setReviewer(Group.findById(3));
		IDHash.put(rt.getId(), rt);
		GroupIDHash.put(rt.getReviewer().getId(), rt);

		rt = new ReviewTemplate();
		rt.setId(2);
		rt.setName("Security Review");
		rt.setActive(true);
		rt.setReviewer(Group.findById(5));
		IDHash.put(rt.getId(), rt);
		GroupIDHash.put(rt.getReviewer().getId(), rt);
		
		rt = new ReviewTemplate();
		rt.setId(3);
		rt.setName("ORD Review");
		rt.setActive(true);
		rt.setReviewer(Group.findById(7));
		IDHash.put(rt.getId(), rt);
		GroupIDHash.put(rt.getReviewer().getId(), rt);

		rt = new ReviewTemplate();
		rt.setId(4);
		rt.setName("OEF-OIF Review");
		rt.setActive(true);
		rt.setReviewer(Group.findById(9));
		IDHash.put(rt.getId(), rt);
		GroupIDHash.put(rt.getReviewer().getId(), rt);

		rt = new ReviewTemplate();
		rt.setId(5);
		rt.setName("Surgery Review");
		rt.setActive(false);				//Surgery is being moved to an Independent Workflow
		rt.setReviewer(Group.findById(11));
		IDHash.put(rt.getId(), rt);
		GroupIDHash.put(rt.getReviewer().getId(), rt);

		rt = new ReviewTemplate();
		rt.setId(1001);
		rt.setName("Capri/VistAWeb");
		rt.setActive(true);
		rt.setReviewer(Group.findById(13));
		IDHash.put(rt.getId(), rt);
		GroupIDHash.put(rt.getReviewer().getId(), rt);
	}
	
}
